/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.interactionhandling;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.PaneBuilders;
import com.ldtteam.blockout.controls.AbstractTextBuilder;
import com.ldtteam.blockout.controls.ButtonImage;
import com.ldtteam.blockout.controls.ItemIcon;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.views.Box;
import com.ldtteam.blockout.views.Window;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.ICitizen;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.IVisitorData;
import com.minecolonies.api.colony.IVisitorViewData;
import com.minecolonies.api.colony.interactionhandling.IChatPriority;
import com.minecolonies.api.colony.interactionhandling.IInteractionResponseHandler;
import com.minecolonies.api.colony.interactionhandling.ModInteractionResponseHandlers;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.interactionhandling.ServerCitizenInteraction;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class RecruitmentInteraction
extends ServerCitizenInteraction {
    private static final String RECRUITMENT_ICON = "recruitIcon";
    private static final ResourceLocation icon = new ResourceLocation("minecolonies", "textures/icons/recruiticon.png");
    private static final Tuple<ITextComponent, ITextComponent> recruitAnswer = new Tuple<TranslationTextComponent, Object>(new TranslationTextComponent("com.minecolonies.coremod.gui.chat.recruit"), null);
    private static final Tuple<ITextComponent, ITextComponent>[] responses = new Tuple[]{new Tuple<TranslationTextComponent, Object>(new TranslationTextComponent("com.minecolonies.coremod.gui.chat.showstats"), null), recruitAnswer, new Tuple<TranslationTextComponent, Object>(new TranslationTextComponent("com.minecolonies.coremod.gui.chat.notnow"), null)};

    public RecruitmentInteraction(ICitizen data) {
        super(data);
    }

    public RecruitmentInteraction(ITextComponent inquiry, IChatPriority priority) {
        super(inquiry, true, priority, (ICitizenData d) -> true, null, responses);
    }

    @Override
    public List<IInteractionResponseHandler> genChildInteractions() {
        return Collections.emptyList();
    }

    @Override
    public String getType() {
        return ModInteractionResponseHandlers.RECRUITMENT.func_110623_a();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onWindowOpened(Window window, ICitizenDataView dataView) {
        ButtonImage recruitButton = (ButtonImage)window.findPaneOfTypeByID("response_2", ButtonImage.class);
        Box group = (Box)window.findPaneOfTypeByID("responseOptions", Box.class);
        if (recruitButton != null && dataView instanceof IVisitorViewData) {
            ItemStack recruitCost = ((IVisitorViewData)dataView).getRecruitCost();
            IColonyView colony = ((IVisitorViewData)dataView).getColonyView();
            ((Text)window.findPaneOfTypeByID("chat", Text.class)).setText(((AbstractTextBuilder.TextBuilder)((AbstractTextBuilder.TextBuilder)((AbstractTextBuilder.TextBuilder)((AbstractTextBuilder.TextBuilder)PaneBuilders.textBuilder().append((IFormattableTextComponent)new StringTextComponent(dataView.getName() + ": "))).append(this.getInquiry())).emptyLines(1)).append((IFormattableTextComponent)new TranslationTextComponent(colony.getCitizens().size() < colony.getCitizenCountLimit() ? "com.minecolonies.coremod.gui.chat.recruitcost" : "com.minecolonies.coremod.gui.chat.nospacerecruit", new Object[]{dataView.getName().split(" ")[0], recruitCost.func_190916_E() + " " + recruitCost.func_200301_q().getString()}))).getText());
            int iconPosX = recruitButton.getX() + recruitButton.getWidth() - 28;
            int iconPosY = recruitButton.getY() + recruitButton.getHeight() - 18;
            ItemIcon icon = new ItemIcon();
            icon.setID(RECRUITMENT_ICON);
            icon.setSize(15, 15);
            group.addChild((Pane)icon);
            icon.setItem(((IVisitorViewData)dataView).getRecruitCost());
            icon.setPosition(iconPosX, iconPosY);
            icon.setVisible(true);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean onClientResponseTriggered(ITextComponent response, PlayerEntity player, ICitizenDataView data, Window window) {
        if (response.equals(recruitAnswer.getA()) && data instanceof IVisitorViewData) {
            if (player.func_184812_l_() || InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)player.field_71071_by), ((IVisitorViewData)data).getRecruitCost().func_77973_b()) >= ((IVisitorViewData)data).getRecruitCost().func_190916_E()) {
                return super.onClientResponseTriggered(response, player, data, window);
            }
            LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"com.minecolonies.coremod.gui.chat.notenoughitems", (Object[])new Object[0]);
        }
        return true;
    }

    @Override
    public void onServerResponseTriggered(ITextComponent response, PlayerEntity player, ICitizenData data) {
        if (response.equals(recruitAnswer.getA()) && data instanceof IVisitorData) {
            IColony colony = data.getColony();
            if (colony.getCitizenManager().getCurrentCitizenCount() < colony.getCitizenManager().getPotentialMaxCitizens()) {
                if (player.func_184812_l_() || InventoryUtils.attemptReduceStackInItemHandler((IItemHandler)new InvWrapper((IInventory)player.field_71071_by), ((IVisitorData)data).getRecruitCost(), ((IVisitorData)data).getRecruitCost().func_190916_E())) {
                    colony.getVisitorManager().removeCivilian(data);
                    data.setWorkBuilding(null);
                    data.setHomeBuilding(null);
                    data.setJob(null);
                    if (colony.getWorld().field_73012_v.nextInt(100) <= (Integer)MineColonies.getConfig().getServer().badVisitorsChance.get()) {
                        LanguageHandler.sendPlayersMessage(colony.getMessagePlayerEntities(), (String)"com.minecolonies.coremod.recruit.runaway", (Object[])new Object[]{data.getName()});
                        return;
                    }
                    ICitizenData newCitizen = colony.getCitizenManager().createAndRegisterCivilianData();
                    newCitizen.deserializeNBT(data.serializeNBT());
                    newCitizen.setParents("", "");
                    newCitizen.updateEntityIfNecessary();
                    data.getEntity().ifPresent(Entity::func_70106_y);
                    if (data.hasCustomTexture()) {
                        LanguageHandler.sendPlayersMessage(colony.getMessagePlayerEntities(), (String)"com.minecolonies.coremod.recruit.message.custom", (Object[])new Object[]{data.getName()});
                    } else {
                        LanguageHandler.sendPlayersMessage(colony.getMessagePlayerEntities(), (String)"com.minecolonies.coremod.recruit.message", (Object[])new Object[]{data.getName()});
                    }
                }
            } else {
                LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"com.minecolonies.coremod.gui.chat.nospace", (Object[])new Object[0]);
            }
        }
    }

    @Override
    public ResourceLocation getInteractionIcon() {
        return icon;
    }
}

